# Vespucci 15.1 Highlights

2020-12-11

### User interface changes and additions

Action modes that require multiple actions are now exited by touching on a floating action button with a check icon instead of via the back button. This effects the way creation mode, creating a relations members, editing a relation and the new create and add to route modes.

All these modes will now further retain state over the Android activity lifecycle.

#### Way creation mode

All additions are now encapsulated in one undo checkpoint, and can be completely undone by one undo operation once the way is created. The undo button visible in the mode will, as previously, remove the last added node, this will however not add extra checkpoints. Aborting the mode will currently retain the way and any created nodes.

#### Create relation mode / Add to relation mode

Available from the element (node, way, relation) selection and multi-select modes. _Create relation_ now asks you to select a relation type before proceeding and _Add to relation_ asks you to select a relation type. Elements can be added and removed. Clickable elements are filtered, when available, by preset role filters. If a role filter matches exactly the role will be set for the member.

#### NEW Add / remove member  

Available in the _Relation selected_ mode allows adding and removing members for the currently selected relation.

#### NEW Create and add to route mode

Available from the Way selected mode. These are specialized modes for building route relations and support auto-splitting of ways. They currently do not support removing route members, that needs to be done via the _Relation selected_ mode. Aborting the modes will not create or modify the relation, however ways that have been split will remain split (as this is done in per way undo checkpoints, individual way splits can be undone if necessary).

### Alternative tagging display

We've added a facility to display alternative tagging for an object that matches a specific preset with such information. Currently this is available via a menu entry in the property editor.

### Removed Help launcher icon

Instead of a launcher icon we now provide a shortcut (long press on the icon) to directly start the help viewer (available on Android 8 and higher. 

### Better reporting and display of tag issues when merging and splitting ways

Issues occurring when a ways are merged or a way is split are now displayed in a dialog in detail, with the option to investigate them via the element information dialog and potentially fix them in the property editor. 

### Feedback form behaviour changes

As github no longer supports logins with user name / password this has been removed as an option for the feedback form. If you have a github account you can change a preference to allow issue creation via the normal github web UI. This will be used automatically if you have the github app installed, however note that while the github app catches the URL it doesn't support documented github API for passing parameters (issue template to use and submitted information). Unluckily there is no reasonable way to submit bug reports to github to get this issue addressed.

### Accessibility improvements

A number of the layouts have been reworked to respond better to changes in font and other screen object scaling, obviously there are limits to what can reasonably be expected to still be functional in an application that. among other things, concerns itself with geographic detail. This is an ongoing activity.

## Miscellaneous

* Display a warning if an imagery tile source is producing many errors. Note: Bing imagery has a tendency to do this in a spurious fashion, this can be ignored.
* Improve handling of preset file parsing issues.
* Custom presets can be deleted by long pressing the icon in the preset tab of the property editor.
* Issue detail and fixing information is now available for OSMOSE bugs. 
* Improved performance in auto-download modes.
* Improved imagery attribution display.
* Colour and line width of the grid/scale display can now be styled. 
* Beep volume can now be set in the Advanced preferences.

# Upgrading from previous versions

* The format of the saved state including data has changed, you should upload any changes before updating.

# Known problems

* The documentation is out of date.
* For other known problems with this build please see [our issue tracker](https://github.com/MarcusWolschon/osmeditor4android/issues)
